<?php

/** 
 * Garbage Collector -   garbage_collector.class.inc.php
 * 
 * (C) Ralf Stadtaus http://www.stadtaus.com/
 */
 
include 'Find.php';



/**
 * 
 */
class garbage_collector
{


    /**
     * Number of files to be deleted at once
     */
    public $number = 20;

    /**
     * Time in minutes until a file gets deleted
     */
    public $time = 120;

    /**
     * Directory that contains the garbage
     */
    public $directory = '';

// -----------------------------------------------------------------------------




    /**
     * Constructor
     */
    function __construct($config)
    {
        
        // Extract configuration array
        if (is_array($config)) {
            $valid = array_keys(get_class_vars(static::class));
            foreach ($config as $key => $val) {
                if (in_array($key, $valid)) {
                    $this->$key = $val;
                }
            }
        }
    }

// -----------------------------------------------------------------------------




    /**
     * Get file list
     */
    function file_list()
    {
        if (!is_dir($this->directory)) {
            return false;
        }
        $items = &File_Find::glob(  '#([a-zA-Z0-9])\.png#', 
                                    $this->directory, 
                                    'perl');
        if (!is_array($items) or count($items) <= 0) {
            return false;
        }
        $list = [];
        foreach ($items as $val) {
            if (count($list) >= ($this->number - 1)) {
                return $list;
            }
            $diff = (time() - filectime($this->directory . $val))/60;
            if ($diff > $this->time) {
                $list[] = $val;
            }
        }
        return $list;
    }

// -----------------------------------------------------------------------------




    /**
     * Display file list
     */
    function display()
    {
        if ($list = $this->file_list()) {
            $list = implode('<br />', $list);
            echo $list;
        }
    }

// -----------------------------------------------------------------------------




    /**
     * Delete files
     */
    function delete()
    {
        if ($list = $this->file_list()) {
            if (!is_array($list)) {
                return false;
            }
            reset($list);
            foreach ($list as $val) {
                if (!is_file($this->directory . $val)) {
                    continue;
                }
                unlink($this->directory . $val);
            }
        }
    }

// -----------------------------------------------------------------------------




} // Scool's out








?>
