<?php

/**
 * Title........: Form Mail Script
 * Filename.....: formmail.class.inc.php
 * Author.......: Ralf Stadtaus
 * Homepage.....: http://www.gentlesource.com/
 */

/**
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY
 * OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
 * LIMITED   TO  THE WARRANTIES  OF  MERCHANTABILITY,
 * FITNESS    FOR    A    PARTICULAR    PURPOSE   AND
 * NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES
 * OR  OTHER  LIABILITY,  WHETHER  IN  AN  ACTION  OF
 * CONTRACT,  TORT OR OTHERWISE, ARISING FROM, OUT OF
 * OR  IN  CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

/**
 */
class Formmail
{
    public $error_template;
    public $new_html_template;
    public $all_content;
    public $replace_content;
    public $environment;
    public $wrap_content;
    public $mail_content;
    public $mail_headers;
    public $multiple;
    // -re- join multiple values by this string
    public $multiple_glue;
    public $selection_content;
    public $control_fields;
    public $table_start;
    public $table_end;
    public $hide_empty_fields;
    public $attachments = [];
    public $honey_pots;
    public $spam_flag = false;
    private $newsletter_fields = [];
    private $http_protocol;
    private $index_file;

    /**
     * Initialize some settings
     */
    public function __construct(private array $configuration)
    {
        $this->hide_empty_fields = 'no'; // yes/no
        $this->table_start = '<table border="0" cellpadding="2" cellspacing="1">';
        $this->table_end = '</table>';
        $this->multiple = 'multiple';
        $this->multiple_glue = ', ';
        $this->mail_headers = ['From:',
            'Content-Type:',
            'Content-Transfer-Encoding:',
            'Cc:',
            'Bcc:',
            'Reply-To:',
            'X-Mailer:',
            'MIME-Version:',
            'User-Agent:',
            'Sender:',
            'X-Envelope-From:',
            'X-Envelope-To:',
            'Envelope-To:',
            'X-Sender:',
            'Content-Return:',
            'Disposition-Notification-Options:',
            'Disposition-Notification-To:',
            'Errors-To:',
            'Return-Receipt-To:',
            'Read-Receipt-To:',
            'X-Confirm-reading-to:',
            'Followup-To:',
            'Original-Recipient:',
            'In-Reply-To:',
            'Priority:',
            'Sensitivity:',
            'Encoding:',
            'boundary=',
            'Return-path:'];

        $this->control_fields = [
            'error_page',
            'thanks',
            'required_fields',
            'email_fields',
            'compare_fields',
            'html_template',
            'mail_template',
            'send',
            'mail_input_validation_result',
            'limit_error_page',
            'phrase',
            'PHPSESSID',
            sha1('dynamic_field')
            ];

        // Extract configuration array
        if (!empty($configuration) and is_array($configuration)) {
            $valid = array_keys(get_class_vars(static::class));
            foreach ($configuration as $key =>  $val) {
                if (in_array($key, $valid)) {
                    $this->$key = $val;
                }
            }
        }

        $this->check_honey_pots();
    }

    /**
     * Dynamic field value
     */
    function get_dynamic_field_value($configuration)
    {
        if ($configuration['dynamic_field'] == true) {

            if (count($_POST) > 0
                    and isset($_POST[sha1('dynamic_field')])) {
                return $_POST[sha1('dynamic_field')];
            }

            if (count($_POST) > 0
                    and !isset($_POST[sha1('dynamic_field')])) {
                return sha1(1);
            }

            return sha1($_SERVER['DOCUMENT_ROOT'] . mktime(date('H'), 0, 0 , date('m'), date('d'), date('Y')));
        }
        return false;
    }

    /**
     * Check dynamic field value
     */
    function check_dynamic_field_value(&$post_data, $configuration)
    {
        if ($configuration['dynamic_field'] != true) {
            return true;
        }
        if (count($_POST) <= 0) {
            return true;
        }
        if (count($_POST) > 0
                and !isset($_POST[sha1('dynamic_field')])) {
            return false;
        }

        $value = $_POST[sha1('dynamic_field')];
        $success = false;
        for ($i = 0; $i <= 5; $i++)
        {
            $dynamic_value = sha1($_SERVER['DOCUMENT_ROOT'] . mktime(date('H') - $i, 0, 0 , date('m'), date('d'), date('Y')));
            if ($value == $dynamic_value) {
                return true;
            }

        }
    }

    /**
     * Check template path
     */
    function check_template_path($path)
    {
        global $txt;

        if (!is_dir($path)) {
            return ['message' => $txt['txt_wrong_template_path']];
        }
    }

    /**
     * Check required fields
     */
    function check_required_fields($required_fields, $data)
    {
        global $txt;

        $check_required_fields = explode(',', (string) $required_fields);
        reset ($check_required_fields);
        $err_msg = '';

        foreach ($check_required_fields as $val)
        {
            $val = trim($val);

            if (!isset($txt['txt_' . $val]) or $txt['txt_' . $val] == '') {
                $txt['txt_' . $val] = $val;
            }
            if (!isset($data[$val]) or $data[$val] == '') {
                $err_msg .= $txt['txt_' . $val] . '<br />';
            }
        }

        if (!empty($err_msg)) {
            return $err_msg;
        }
    }

    function check_required_fields_array($required_fields, $data)
    {
        $check_required_fields = explode(',', (string) $required_fields);
        reset ($check_required_fields);

        foreach ($check_required_fields as $val) {
            $val = trim($val);
            // -re- TODO: accept string '0' as NOT empty!!!
            if (empty ($data[$val])) {
                $fields[] = $val;
            }
        }

        if (!empty($fields)) {
            return $fields;
        }
    }

    private function get_email_fields($email_fields)
    {
        $fields = explode(',', (string) $email_fields);

        foreach ($fields as $key => $value)
        {
            $fields[$key] = trim($value);
        }

        return $fields;
    }

    /**
     * Check email fields
     */
    public function check_email_fields($email_fields, $data)
    {
        global $txt;

        $check_email_fields = $this->get_email_fields($email_fields);
        $err_msg = '';

        foreach ($check_email_fields as $val) {

            if (
                !empty($data[$val])
                and !filter_var($data[$val], FILTER_VALIDATE_EMAIL)
            ) {
                if (empty($txt['txt_' . $val])) {
                    $txt['txt_' . $val] = $val;
                }
                $err_msg .= $txt['txt_' . $val] . '<br />';
            }
        }

        if (!empty($err_msg)) {
            return $err_msg;
        }
    }

    function check_email_fields_array($email_fields, $data)
    {
        global $txt;

        $check_email_fields = explode(',', (string) $email_fields);
        reset ($check_email_fields);

        foreach ($check_email_fields as $val) {
            $val = trim($val);

            if (isset($data[$val]) and !empty($data[$val]) and !filter_var($data[$val], FILTER_VALIDATE_EMAIL)) {
                $fields[] = $val;
            }
        }

        if (!empty($fields)) {
            return $fields;
        }
    }

    /**
     * Check compare fields
     */
    function check_compare_fields($fields, $data, &$message)
    {
        global $txt;

        if (!is_array($fields)) {
            return false;
        }

        $num = count($fields);
        $err_fields = '';
        for ($i = 0; $i < $num; $i++)
        {
            $field_names = explode(',', (string) $fields[$i]);
            if (count($field_names) < 2) {
                continue;
            }

            $numj = count($field_names);
            for ($j = 1; $j < $numj; $j++)
            {
                $field_names[$j-1] = trim($field_names[$j-1]);
                $field_names[$j] = trim($field_names[$j]);
                if ($data[$field_names[$j-1]] != $data[$field_names[$j]]) {
                    if (!isset($txt['txt_' . $field_names[$j-1]]) or $txt['txt_' . $field_names[$j-1]] == '') {
                        $txt['txt_' . $field_names[$j-1]] = $field_names[$j-1];
                    }
                    if (!isset($txt['txt_' . $field_names[$j]]) or $txt['txt_' . $field_names[$j]] == '') {
                        $txt['txt_' . $field_names[$j]] = $field_names[$j];
                    }
                    $err_fields .= $txt['txt_' . $field_names[$j-1]] . $txt['txt_compare_and'] . $txt['txt_' . $field_names[$j]] . '<br />';
                }
            }
        }
        if ($err_fields != '') {
            $message[] = ['message' => $txt['txt_error_compare'], 'fields' => $err_fields];
        }
    }

    /**
     * Check whether the user is allowed to send e-mails
     * based on the sender or recipient e-mail address
     */
    function check_value_limit($check_value, $count, $duration, $field, $err_msg)
    {
        //global $filepath;

        if (!empty($count) and $count > 0) {
            if (is_file($this->configuration['filepath']['logfile'] . 'logfile.txt')) {
                $check = '';
                $limit_errors_flag = '';

                $read_logfile = fopen($this->configuration['filepath']['logfile'] . 'logfile.txt', "r");

                while ($line = fgets($read_logfile, 4096)) {
                    $data = explode('%%', $line);

                    if ($check_value == trim($data[$field]) and $data[1] > time() - $duration * 60 * 60) {
                        $check++;
                    }
                }
                fclose ($read_logfile);

                if ($count > 0 and !empty ($count) and $check >= $count) {
                    return $err_msg;
                }
            }
        }
    }

    function check_honey_pots()
    {
        if (isset($this->honey_pots) and !empty($this->honey_pots)) {
            $honey_pot_fields = explode(',', $this->honey_pots);
            foreach ($honey_pot_fields as $honey_pot_field) {
                if (isset($_POST[trim($honey_pot_field)]) and !empty($_POST[trim($honey_pot_field)])) {
                    $this->spam_flag = true;
                    break;
                }
            }
        }
    }

    /**
     * Generate array that contains all form data except
     * the control fields (hidden form fields).
     *
     * -re- Enhanced to handle multiple selects and several checkboxes with the same name.
     * -re- This requires checkbox/select names to be written as ... name="my_name[]" ...
     * -re- to force their delivery as arrays into $_POST. No other changes are required in form and form template.
     */
    function generate_all_content($data)
    {
        $match_content = implode('|', $this->control_fields);
        $match_content = "/$match_content/i";
        $all_content = [];
        $all_content_table[] = $this->table_start;
        $count = 0;

        foreach ($data as $key => $val) {
            if (preg_match($match_content, (string) $key) > 0) {
                continue;
            }

            if (is_array($val)) {
                $val = implode($this->multiple_glue, $val);
            }

            if ($this->hide_empty_fields == 'yes' and $val == '') {
                continue;
            }

            $all_content[] = $key . ': ' . $val;
            $even_odd = (($count % 2) == 0) ? 'even' : 'odd';
            $all_content_table[] = '<tr class="' . $even_odd . '"><td class="key">' . $key . '</td><td class="val">' . nl2br((string) $val) . '</td></tr>';
            $count++;
        }

        $all_content_table[] = $this->table_end;

        $content = ['all_content' => implode("\n", $all_content),
            'all_content_table' => implode("\n", $all_content_table)];

        return $content;
    }

    /**
     * Generate array that contains all form data field
     * names and their counterpart variables ({...}).
     */
    function generate_form_variables($data, $txt)
    {
        $match_content = implode('|', $this->control_fields);
        $match_content = "/$match_content/i";
        $form_variables = '';

        foreach ($data as $key => $val) {
            if (!preg_match($match_content, (string) $key)) {
                if (isset($txt['txt_' . $key])) {
                    $my_key = $txt['txt_' . $key];
                } else {
                    $my_key = $key;
                }

                $form_variables .= $my_key . ': {' . $key . "}\n";
            }
        }

        return $form_variables;
    }

    /**
     * Replace placeholders with string or array values
     * replace_values( string subject, mixed replacement
     * variable name)
     */
    function replace_values($content, $values)
    {
        //global ${$values};

        $this->replace_content = $content;

        if (is_array($values)) {
            reset($values);

            foreach($values as $key => $val) {
                // -re- account for array values (multiple select/checkbox)
                if (is_array($val)) {
                    $val = implode($this->multiple_glue, $val);
                }
                $this->replace_content = preg_replace('#\{(checkbox:|select:|radiobutton:|)' . preg_quote((string) $key, '#') . '\}#', preg_quote((string) $val, '#'), (string) $this->replace_content);
            }
        } else if (is_string($values)) {
            // -re- account for array values (multiple select/checkbox)
            // if (is_array($val)) {
            // $val = join($this->multiple_glue, $val);
            // }
            $this->replace_content = preg_replace('#\{(checkbox:|select:|radiobutton:|)' . preg_quote($values, '#') . '\}#', preg_quote($values, '#'), (string) $this->replace_content);
        }

        return $this->replace_content;
    }

    /**
     * Remove unselected cheboxes and radio buttons from
     * template.
     */
    function remove_values($content)
    {
        $this->replace_content = preg_replace('#\{(checkbox|select|radiobutton):(.*?)\}#', '', (string) $content);

        return $this->replace_content;
    }

    /**
     * Generate environment variables
     */
    function get_environment_var($input)
    {
        $time = explode(' ', date("Y m d H i s", time()));

        $this->environment = ['env_user_agent' => $input['HTTP_USER_AGENT'] , 'env_remote_address' => $input['REMOTE_ADDR'] , 'env_remote_host' => @gethostbyaddr($input['REMOTE_ADDR']) , 'env_year' => $time[0] , 'env_month' => $time[1] , 'env_day' => $time[2] , 'env_hour' => $time[3] , 'env_minute' => $time[4] , 'env_second' => $time[5] , 'env_iso_date' => $time[0] . '-' . $time[1] . '-' . $time[2] . ' (' . $time[3] . ':' . $time[4] . ':' . $time[5] . ')'

            ];

        return $this->environment;
    }

    /**
     * In case $text_wrap contains a value and that value
     * consists only on numbers wrap the text.
     * text_wrap(string str, int width [, string break])
     */
    function wrap_content($content, $width, $break = "\n")
    {
        $this->wrap_content = $content;

        if (isset($width) and !empty($width) and preg_match("/^[0-9]+$/", (string) $width)) {
            $this->wrap_content = wordwrap((string) $this->wrap_content, $width, $break);
        }

        return $this->wrap_content;
    }

    /**
     */
    function validate_to($content)
    {
        $header_info = explode("\n", (string) $content);

        for($k = 0; $k < count($header_info); $k++) {
            $clean_header = trim($header_info[$k]);
            if (empty($clean_header)) {
                break;
            }

            if (preg_match("/To:/i", $header_info[$k])) {
                $mail_recipient = trim((string) preg_replace("/To:/i", '', $header_info[$k]));
            }
        }

        if (!isset($mail_recipient)) {
            return false;
        }

        if (preg_match("/[a-z0-9_-]+(\.[a-z0-9_-]+)*@([0-9a-z][0-9a-z-]*[0-9a-z]\.)+([a-z]{2,10})/i", $mail_recipient)) {
            return true;
        }

        return false;
    }

    /**
     */
    function collect_multiples($fields)
    {
        if (!empty($fields) and is_array($fields)) {
            foreach ($fields as $key => $val) {
                if (preg_match("#^" . $this->multiple . "_(.*?)_([0-9])$#i", (string) $key, $matches) > 0) {
                    if (isset($matches[2]) and is_numeric($matches[2])) {
                        $multiple[$matches[2]][$matches[1]] = $val;
                    }
                }
            }
        }

        if (!isset($multiple)) {
            $multiple = [];
        }

        return $multiple;
    }

    /**
     * -re- TODO: Hmmm, maybe this must be adapted to multiple selects and multiple checkboxes too?
     * -re-       I don't have the time to do that now, maybe Ralf does?
     */
    function replace_multiples($content, $values)
    {
        for ($i = 0, $num = count($content); $i < $num; $i++) {
            if (is_array($values)) {
                reset($values);

                foreach($values as $key => $val) {
                    $temp_content = $content[$i];

                    foreach($val as $k => $v) {
                        $temp_content = preg_replace('#\{(checkbox:|select:|radiobutton:|)' . $this->multiple . '_' . $k . '_\?\}#', '{' . $this->multiple . '_' . $k . '_' . $key . '}', (string) $temp_content);
                    }
                    if ($old_content == $temp_content) {
                        continue;
                    }
                    $new_content[] = $temp_content;
                    $old_content = $temp_content;
                }
            }
        }

        if (isset($new_content)) {
            return $new_content;
        } else {
            return $content;
        }
    }

    /**
     * Add name of files to be attached to the script
     */
    function add_attachments($arr)
    {
        $this->attachments = $arr;
    }

    /**
     *
     */
    private function contains_confirmation_link($content)
    {
        if (str_contains((string) $content, '{confirmation_link}')) {
            return true;
        }
    }

    private function create_confirmation_link($data)
    {
        if (count($this->newsletter_fields) <= 0) {
            return false;
        }

        if (isset($_POST['email_fields'])) {
            $email_fields = $this->get_email_fields($_POST['email_fields']);
        }

        if (count($email_fields) <= 0) {
            return false;
        }

        if (!isset($data[current($email_fields)])) {
            return false;
        }

        $email = $data[current($email_fields)];
        $create = false;

        foreach ($this->newsletter_fields as $field)
        {
            if (isset($data[$field])) {
                $create = true;
                break;
            }
        }

        if ($create == false) {
            return false;
        }

        $url = $this->http_protocol . '://' . $_SERVER["HTTP_HOST"] . $_SERVER["REQUEST_URI"] . '?c=' . $this->encrypt_string($email);

        return $url;
    }

    /**
     * Create parameters for thanks page
     *
     * Example usage
     *
     * function appointmind_decrypt($encrypted, $key)
     * {
     *      $cipher = 'aes-256-cbc';
     *
     *   	if (!in_array($cipher, openssl_get_cipher_methods())) {
     *   		return false;
     *   	}
     *
     *   	if (mb_strpos($encrypted, ':') === false) {
     *   		return false;
     *   	}
     *
     *      $encrypted  = rawurldecode($encrypted);
     *   	$iv 		= mb_substr($encrypted, 0, mb_strpos($encrypted, ':'));
     *   	$data 		= mb_substr($encrypted, mb_strpos($encrypted, ':') + 1, mb_strlen($encrypted));
     *
     *   	return openssl_decrypt($data, $cipher, $key, 0, base64_decode($iv));
     * }
     *
     *   $encryptionKey = '1234ABCD';
     *
     *   if (isset($_GET['data'])) {
     *   	print_r(json_decode(appointmind_decrypt($_GET['data'], $encryptionKey)));
     *   }
     *
     *
     * @param array $appointment
     * @param string $url
     * @return string
     */
    public function encrypt_string($string)
    {
        $encryptionKey = $this->encryption_key();
        $cipher = 'aes-256-cbc';
        $iv = null;

        if (!empty($encryptionKey)
                and in_array($cipher, openssl_get_cipher_methods())) {
            $iv = openssl_random_pseudo_bytes(openssl_cipher_iv_length($cipher));
        }

        if (is_null($iv)) {
            return '';
        }

        $encrypted = openssl_encrypt($string, $cipher, $encryptionKey, 0, $iv);
        $encrypted = base64_encode((string) $iv) . ':' . $encrypted;
        $encrypted = rawurlencode($encrypted);

        return $encrypted;
    }

    private function encryption_key()
    {
        return hash('sha256', __DIR__ . $_SERVER['SERVER_SOFTWARE'] . $_SERVER['SERVER_ADDR']);
    }

    public function decrypt_string($encrypted)
    {
        $cipher = 'bf-cbc';

        if (!in_array($cipher, openssl_get_cipher_methods())) {
            return false;
        }

        if (mb_strpos((string) $encrypted, ':') === false) {
            return false;
        }

        $encrypted  = rawurldecode((string) $encrypted);
        $iv 		= mb_substr($encrypted, 0, mb_strpos($encrypted, ':'));
        $data 		= mb_substr($encrypted, mb_strpos($encrypted, ':') + 1, mb_strlen($encrypted));

        return openssl_decrypt($data, $cipher, $this->encryption_key(), 0, base64_decode($iv));
    }

    /**
     * Replace placeholders in mail templates and send
     * e-mails.
     */
    public function send_mail($mail_content, $content_data, $post_data = null)
    {
        global $text_wrap, $my_sendmail, $send_alternative_mail,
        $debug_mode, $sender_count,
        $sender_duration, $recipient_count,
        $recipient_duration, $txt, $remove_tags, $tplt,
        $configuration;

        $multiple = $this->collect_multiples($post_data);
        $mail_content = $this->replace_multiples($mail_content, $multiple);

        for ($i = 0; $i < count($mail_content); $i++)
        {
            // Handle newsletter confirmation link
            if ($this->contains_confirmation_link($mail_content[$i])) {
                $confirmation_link = $this->create_confirmation_link($post_data);
                if (!$confirmation_link) {
                    continue;
                }
                $mail_content[$i] = $this->replace_values($mail_content[$i], ['confirmation_link' => $confirmation_link]);
            }

            /**
             * Replace placeholder with form, text (from language
             * file) and environment data
             */
            $mail_content[$i] = $this->replace_values($mail_content[$i], $post_data);

            $mail_content[$i] = $this->replace_values($mail_content[$i], $txt);

            $mail_content[$i] = $this->replace_values($mail_content[$i], $content_data);

            $mail_content[$i] = $this->replace_values($mail_content[$i], $this->get_environment_var($_SERVER));


            //$mail_content[$i] = $this->replace_values($mail_content[$i], $url);

            /**
             * Remove unselected value placeholders
             */
            $mail_content[$i] = $this->remove_values($mail_content[$i]);

            /**
             * Remove tags
             */
            // $mail_content[$i] = $this->clean_output($mail_content[$i], $remove_tags);
            /**
             * Strip slashes
             */
            $final_mail_content = stripslashes((string) $mail_content[$i]);

            if ($this->validate_to($final_mail_content) == false) {
                continue;
            }

            /**
             * Check whether the user is allowed to send e-mails
             * with or to a certain e-mail address.
             */
            $sender = $this->get_header_info($mail_content[$i], 'From');
            $recipient = $this->get_header_info($mail_content[$i], 'To');

            // Check if recipient is blocked by domain
            if (count($configuration['recipients_domains']) > 0) {
                foreach ($configuration['recipients_domains'] AS $recipient_domain)
                {
                    $domain = '#' . preg_quote(trim((string) $recipient_domain)) . '#';
                    if (preg_match($domain, (string) $recipient) === 1) {
                        return ['status' => 'failed', 'message' => [], 'mail_content' => $mail_content[$i]];
                    }
                }
            }
            if ($tplt == 'recom') {

                if ($limit = $this->check_value_limit($sender, $sender_count, $sender_duration, 4, $txt['txt_sender_expiration'])) {
                    $message[] = ['message' => $limit, 'fields' => ''];
                }

                if ($limit = $this->check_value_limit($recipient, $recipient_count, $recipient_duration, 5, $txt['txt_recipient_expiration'])) {
                    $message[] = ['message' => $limit, 'fields' => ''];
                }

                if (isset($message) and !empty($message)) {
                    return ['status' => 'failed', 'message' => $message];
                }
            }

            /**
             * Start attachment handling
             */
            $send_attachments = false;
            if (!empty($this->attachments) and is_array($this->attachments)) {
                $send_alternative_mail = 'yes';
                $send_attachments = true;
            }
			if (isset($configuration['attach_mail_vars'])
					and is_array($configuration['attach_mail_vars'])
					and count($configuration['attach_mail_vars']) > 0) {
                $send_alternative_mail = 'yes';
                $send_attachments = true;
			}

            /**
             * Force use of htmlMimeMail class for UTF-8 to properly encode headers with umlauts
             */
            if (strtoupper($configuration['character_set']) == 'UTF-8') {
                $send_alternative_mail = 'yes';
            }

            /**
             * Get sendmail path from php ini settings or use the
             * value of $my_sendmail.
             */
            if ($send_alternative_mail != 'yes') {
                if (isset($configuration['flag_spam']) and $configuration['flag_spam'] and $this->spam_flag) {
                    $pos = strpos($final_mail_content, 'Subject:');
                    if ($pos !== false) {
                        $final_mail_content = substr_replace($final_mail_content, 'Subject: [SPAM] ', $pos, strlen('Subject:'));
                    }
                }
                $sendmail = @ini_get('sendmail_path');

                debug_mode($sendmail, 'ini_get()');

                if (empty($sendmail)) {
                    $sendmail = "/usr/sbin/sendmail -t ";
                    debug_mode($sendmail, 'empty($sendmail)');
                }

                if (isset($my_sendmail) and !empty($my_sendmail)) {
                    $sendmail = $my_sendmail;
                    debug_mode(['$my_sendmail', $sendmail]);
                }

                /**
                 * Try to send e-mail by using popen() to access
                 * sendmail.
                 */
                if ($fd = @popen($sendmail, "w")) {
                    if (!@fwrite($fd, $final_mail_content . "\n")) {
                        $send_alternative_mail = 'yes';
                        debug_mode([$txt['txt_popen_error'] . ' - fputs()', gettype($fd), $fd]);
                    }
                    pclose($fd);
                } else {
                    $send_alternative_mail = 'yes';
                    debug_mode([$txt['txt_popen_error'] . ' - popen()', gettype($fd), $fd]);
                }

                debug_mode($final_mail_content, 'Mail Content popen()');
            }

            /**
             * If popen() - or fputs() - fails, extract mail
             * header from the template and use the PHP  function
             * mail().
             */
            if ($send_alternative_mail == 'yes') {
                $header_info = explode("\n", $final_mail_content);
                $mail_subject = '';
                $mail_header = $this->mail_headers;
                $mail_header = implode('|', $mail_header);

                unset($additional_headers);
                $attachment_headers = [];

                for($k = 0; $k < count($header_info); $k++)
                {
                    $clean_header = trim($header_info[$k]);
                    if (empty($clean_header)) {
                        break;
                    }

                    if (preg_match("/^From:/i", $header_info[$k])) {
                        $mail_from = trim((string) preg_replace("/From:/i", '', $header_info[$k]));
                        $attachment_headers['From'] = $mail_from;
                        unset($header_info[$k]);
                        continue;
                    }

                    if (preg_match("/^To:/i", $header_info[$k])) {
                        $mail_recipient = trim((string) preg_replace("/^To:/i", '', $header_info[$k]));
                        unset($header_info[$k]);
                        continue;
                    }

                    if (preg_match("/^Subject:/i", $header_info[$k])) {
                        $mail_subject = trim((string) preg_replace("/^Subject:/i", '', $header_info[$k]));
                        unset($header_info[$k]);
                        continue;
                    }

                    if (preg_match("/^X-Form-Mail-Attachment:/i", $header_info[$k])) {
                        if (trim(str_replace('X-Form-Mail-Attachment:', '', $header_info[$k])) == 'no') {
                            $send_attachments = false;
                        }
                        unset($header_info[$k]);
                        continue;
                    }

                    if (preg_match("/^" . $mail_header . "/i", $header_info[$k], $match)) {
                        $additional_headers[] = $header_info[$k];
                        $attachment_headers[str_replace(':', '', $match[0])] = trim((string) preg_replace("/" . $match[0] . "/i", '', $header_info[$k]));
                        unset($header_info[$k]);
                        continue;
                    }
                }

                if (isset($header_info) and is_array($header_info)) {
                    $new_mail_content = trim(implode("\n", $header_info));
                    $new_mail_content = str_replace("\r", '', $new_mail_content);
                } else {
                    $new_mail_content = '';
                }

//                if (isset($additional_headers) and is_array($additional_headers)) {
//                    $additional_headers = implode($additional_headers, "\n");
//                } else {
//                    $additional_headers = '';
//                }


                if (isset($configuration['flag_spam']) and $configuration['flag_spam'] and $this->spam_flag) {
                    $mail_subject = '[SPAM] ' . $mail_subject;
                }

                /**
                 * Wrap mail content (and only mail content - not
                 * headers).
                 */
                $new_mail_content = $this->wrap_content($new_mail_content, $text_wrap);



				/**
				 * Send mail using simple mail function
				 */
                if (!$send_attachments and $debug_mode != 'on' and $mail_recipient != '') {
                    //  @mail ($mail_recipient, $mail_subject, $new_mail_content, $additional_headers);
                    send_mail($mail_recipient, $mail_subject, $new_mail_content, $mail_from, $attachment_headers);
                }

				/**
				 * Send mail using mail class
				 */
                if ($send_attachments and $debug_mode != 'on' and $mail_recipient != '') {
                    $att = new htmlMimeMail();
                    // Switch to smtp mode
                    if ($configuration['mail_type'] == 'smtp') {
                        $type = 'smtp';
                        $smtp = $configuration['smtp'];
                        $att->setSMTPParams($smtp['host'],
                            $smtp['port'],
                            $smtp['helo'],
                            $smtp['auth'],
                            $smtp['user'],
                            $smtp['pass']);
                    } else {
                        $type = 'mail';
                    }
                    // Register file attachments in mime class
                    foreach($this->attachments as $file_name)
                    {
                        $att->addAttachment($att->getFile($file_name['new']), $file_name['old']);
                    }

	                //Manage mail var attachments
	                if (isset($configuration['attach_mail_vars'])
	                		and is_array($configuration['attach_mail_vars'])
	                		and count($configuration['attach_mail_vars']) > 0) {
	               		foreach ($configuration['attach_mail_vars'] AS $attach_type)
	               		{
	               		    if ($attach_type == 'vcard') {
                                $attach_config = [
                                                    'mailvars'  => $post_data,
                                                    'type'      => G10E_ATTACH_TYPE_VCARD,
                                                    'control'   => $this->control_fields
                                                    ];
	               		    	if ($res = attach_mail_variables::get_content($attach_config)) {
	               		    	    $att->addAttachment($res, 'vcard.vcf');
	               		    	}
	               		    }
	               		    if ($attach_type == 'csv') {
                                $attach_config = [
                                                    'mailvars'  => $post_data,
                                                    'type'      => G10E_ATTACH_TYPE_CSV,
                                                    'control'   => $this->control_fields,
                                                    'csv_head'  => true
                                                    ];
	               		    	if ($res = attach_mail_variables::get_content($attach_config)) {
	               		    	    $att->addAttachment($res, 'csv.csv');
	               		    	}
	               		    }
	               		}
	                }
                    // Register headers in mime class
                    $html = false;
                    if (isset($attachment_headers) and is_array($attachment_headers)) {
                        foreach($attachment_headers as $key => $val)
                        {
                            $att->setHeader($key, $val);
                            if ($key == 'Content-Type' and preg_match('#text/html#i', $val)) {
                                $att->setHtmlCharset($configuration['character_set']);
                                $att->setHtml($new_mail_content);
                                $html = true;
                            }
                        }
                    }
                    $att->setHeadCharset($configuration['character_set']);
                    $att->setSubject($mail_subject);
                    if ($html != true) {
                        $att->setTextCharset($configuration['character_set']);
                        $att->setText($new_mail_content);
                    }
                    $att->send([$mail_recipient], $type);
                }

                debug_mode($mail_recipient, 'Mail Recipient mail()');
                debug_mode($mail_subject, 'Mail Subject mail()');
                debug_mode($new_mail_content, 'Mail Content mail()');
                debug_mode($additional_headers, 'Mail Additional Headers mail()');
            }
        } // -re- for
        $this->mail_content = $mail_content[0];

        return ['status' => 'ok', 'mail_content' => $this->mail_content];
    }

    /**
     * Write entry in log file - logfile format: IP - Unix timestamp - date - time - sender - recipient - mail content
     */
    function log_message($mail_content, $log_messages, $ip_address_count, $filepath, $txt, $tplt, $sender_count, $recipient_count)
    {
        //global $log_messages, $ip_address_count, $filepath, $txt, $tplt, $sender_count, $recipient_count;

        $message_sender = $this->get_header_info($mail_content, 'From');
        $message_recipient = $this->get_header_info($mail_content, 'To');

        if ($log_messages == 'yes' or $ip_address_count > 0 or ($tplt == 'recom' and ($sender_count > 0 or $recipient_count > 0))) {
            if ($logfile = @fopen($filepath['logfile'] . 'logfile.txt', 'a')) {
                @flock($logfile, 2) or debug_mode($txt['txt_cannot_lock_file'] . $filepath['logfile'] . 'logfile.txt');
                $current_time = time();
                $logfile_content = [getenv('REMOTE_ADDR'), $current_time, date ("Y-m-d", $current_time), date("H:i:s", $current_time), $message_sender, $message_recipient, str_replace ("\n", ' ', str_replace ("\r", '', $mail_content))];
                $logfile_content = implode('  %%  ', $logfile_content);
                @fwrite ($logfile, $logfile_content . "\n");
                @fclose ($logfile);
            } else {
                debug_mode($filepath['logfile'] . 'logfile.txt', $txt['txt_cannot_open_file']);
            }
        }
    }

    /**
     * Write csv file
     */
    function write_csv_file($post_data)
    {
        global $log_messages, $txt, $filepath;

        if ($log_messages == 'yes') {
            unset($post_data['fs']);
            unset($post_data['fn']);
            $config = [
                'mailvars'  => $post_data,
                'type'      => G10E_ATTACH_TYPE_CSV,
                'control'   => $this->control_fields,
                'csv_head'  => false
                ];
            if ($res = attach_mail_variables::get_content($config)) {
                if ($logfile = @fopen($filepath['logfile'] . 'formdata.csv', 'a')) {
                    @flock($logfile, 2) or debug_mode($txt['txt_cannot_lock_file'] . $filepath['logfile'] . 'formdata.csv');

                    $line = date ('Y-m-d');
                    $line .= G10E_ATTACH_TYPE_CSV_DELIMITER . date('H:i:s');
                    $line .= G10E_ATTACH_TYPE_CSV_DELIMITER . $res;
                    $line = str_replace ("\n", ' ', str_replace ("\r", ' ', $line));

                    @fwrite ($logfile, $line . "\n");
                    @fclose ($logfile);
                } else {
                    debug_mode($filepath['logfile'] . 'formdata.csv', $txt['txt_cannot_open_file']);
                }
            }
        }
    }

    /**
     * Get mail header information
     */
    function get_header_info($mail_content, $header)
    {
        preg_match("#" . $header . ":(.*?)<(.*?)>#i", (string) $mail_content, $match);

        if (!isset($match[2]) or empty($match[2])) {
            preg_match("#$" . $header . ":(.*?)\n#i", (string) $mail_content, $match);
            $match = $match[1];
        } else {
            $match = $match[2];
        }

        return trim($match);
    }

    /**
     * Check selected checkboxes, radio buttons and select
     * menu options and replace values in template.
     *
     * -re- Enhanced to handle multiple selects and several checkboxes with the same name.
     * -re- This requires checkbox/select names to be written as ... name="my_name[]" ...
     * -re- to force their delivery as arrays into $_POST. No other changes are required in form and form template.
     */
    function register_selections($content, $data = [])
    {
        $data = (array) $data;

        foreach ($data as $key =>  $val)
        {
            if (is_array($val)) {
                foreach ($val as $multiple) {
                    /**
                     * -re- Check multiple selected checkboxes with the same name and multiple select menu options.
                     */
                    $content = preg_replace("#\{checkbox:" . preg_quote((string) $key, '#') . "=" . preg_quote((string) $multiple, '#') . "\}#i", 'checked="checked"', (string) $content);
                    $content = preg_replace("#\{select:" . preg_quote((string) $key, '#') . "=" . preg_quote((string) $multiple, '#') . "\}#i", 'selected="selected"', (string) $content);
                }

                /**
                 * -re- Replace values in template with comma separated list.
                 */
                $multiple = nl2br(implode($this->multiple_glue, $val));
                $content = preg_replace("#\{checkbox:" . preg_quote((string) $key, '#') . "\}#i", preg_quote($multiple, '#'), (string) $content);
                $content = preg_replace("#\{select:" . preg_quote((string) $key, '#') . "\}#i", preg_quote($multiple, '#'), (string) $content);
            } else {
                /**
                 * Check selected checkboxes, radio buttons and select
                 * menu options.
                 */
                $content = preg_replace("#\{checkbox:" . preg_quote((string) $key, '#') . "=" . preg_quote((string) $val, '#') . "\}#i", 'checked="checked"', (string) $content);
                $content = preg_replace("#\{radiobutton:" . preg_quote((string) $key, '#') . "=" . preg_quote((string) $val, '#') . "\}#i", 'checked="checked"', (string) $content);
                $content = preg_replace("#\{select:" . preg_quote((string) $key, '#') . "=" . preg_quote((string) $val, '#') . "\}#i", 'selected="selected"', (string) $content);

                /**
                 * Replace values in template.
                 */
                $content = preg_replace("#\{checkbox:" . preg_quote((string) $key, '#') . "\}#i", preg_quote((string) $val, '#'), (string) $content);
                $content = preg_replace("#\{radiobutton:" . preg_quote((string) $key, '#') . "\}#i", preg_quote((string) $val, '#'), (string) $content);
                $content = preg_replace("#\{select:" . preg_quote((string) $key, '#') . "\}#i", preg_quote((string) $val, '#'), (string) $content);
            }
        }

        $content = preg_replace("#\{checkbox:(.*?)\}#i", '', (string) $content);
        $content = preg_replace("#\{radiobutton:(.*?)\}#i", '', (string) $content);
        $content = preg_replace("#\{select:(.*?)\}#i", '', (string) $content);

        $selection_content = stripslashes((string) $content);

        return $selection_content;
    }

    /**
     * Clean form output
     */
    function clean_output($content, $remove_tags)
    {
        if (isset($remove_tags[0]) and $remove_tags[0] == 'yes') {
            if (isset($remove_tags[1])) {
                $content = str_replace('-', '%%+_+%%', $content);
                $content = strip_tags($content, $remove_tags[1]);
                $content = str_replace('%%+_+%%', '-', $content);
            }
        }

        return $content;
    }

    /**
     * Get file field names
     */
    function file_fields($html)
    {
        preg_match_all('/input(.*?)type="file"(.*?)name="(.*?)"(.*?)/', (string) $html, $matches);

        if (isset($matches[3])) {
            return $matches[3];
        }
    }

    public function csv_confirmation_links($filename, $column)
    {

        $result = $filename . '.result';
        $path = str_replace('index.php', '', $_SERVER['PHP_SELF']);

        if (empty($filename)) {
            print_a('Failed');
            return false;
        }

        if (!file_exists($filename)) {
            print_a('Failed');
            return false;
        }

        file_put_contents($result, '');
        $handle = fopen($filename, 'r');

        if (!$handle) {
            print_a('Failed');
            return false;
        }

        while (($buffer = fgets($handle, 4096)) !== false)
        {
            $data = explode(';', trim($buffer));
            $data[] = $this->http_protocol . '://' . $_SERVER["HTTP_HOST"] . $path . '?c=' . $this->encrypt_string($data[$column]);
            file_put_contents($result, implode(';', $data) . "\n", FILE_APPEND);
        }
        if (!feof($handle)) {
            echo "Error: unexpected fgets() fail\n";
        }
        fclose($handle);
        print_a('Success');
    }

    /**
     * Error HTML content
     */
    function load_error_template()
    {
        $this->error_template = '<?xml version="1.0"?>
<!doctype html public "-//W3C//DTD XHTML 1.0 Transitional//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
                                                          <head>
                                                            <title>{txt_script_name} {txt_script_version}</title>
                                                            <meta http-equiv="Content-Type" content="text/html; {txt_charset}" />
                                                          </head>

                                                          <style type="text/css">
                                                          <!--
                                                            h4 {
                                                                font-family:Courier New,Sans-serif;
                                                                }

                                                            p, td, br, form, div, span {
                                                                font-family:Courier New,Sans-serif;
                                                                font-size:9.5pt;
                                                                }

                                                            .code {
                                                                font-family:Courier New,Sans-serif;
                                                                }

                                                            .code strong {
                                                                color:#FF9F00;
                                                                }

                                                            #poweredby {
                                                                text-align:center;
                                                                }

                                                            #poweredby span {
                                                                font-family:Arial,Helvetica,Sans-serif;
                                                                }


                                                          -->
                                                          </style>

                                                          <body>

                                                          <p class="code"><strong>{txt_system_message}</strong></p>
                                                          <LOOP NAME="system_message">
                                                            <p class="code">{message}<br /><br /><br /></p>
                                                          </LOOP NAME="system_message">



                                                          <p>&nbsp;</p>
                                                          <p>&nbsp;</p>


                                                        </body>
                                                        </html>

                                                  ';

        return $this->error_template;
    }
}