<?php

$image_temp_path = $configuration['temp_folder'];
$captcha_content = '';
$captcha_note    = '';

if (!function_exists('file_put_contents')) {
    function file_put_contents($filename, $content, $flags = 0) {
        if (!($file = fopen($filename, ($flags & 1) ? 'a' : 'w'))) {
            return false;
        }
        $n = fwrite($file, (string) $content);
        fclose($file);
        return $n ?: false;
    }
}

// Start PHP session support
session_start();
unset($GLOBALS['phrase']);

$ok = false;


if ($_SERVER['REQUEST_METHOD'] == 'POST' and !isset($_POST['mode_preview']) and !isset($message)) {

    if (isset($_POST['phrase']) && isset($_SESSION['phrase']) &&
        strlen((string) $_POST['phrase']) > 0 && strlen((string) $_SESSION['phrase']) > 0 &&
        strtolower((string) $_POST['phrase']) == strtolower((string) $_SESSION['phrase'])) {
        $ok = true;
    } else {
        $message[] = ['message' => $txt['txt_captcha_try_again'], 'fields' => ''];
    }


    if (is_file($image_temp_path . session_id() . '.png')) {
        unlink($image_temp_path . session_id() . '.png');
    }

}


if (!$ok) {

    require_once __DIR__ . '/lib/Text/CAPTCHA.php';

    $captcha_error = false;

    // Set CAPTCHA options (font must exist!)
    $options = [
        'font_size' => 20,
        'font_path' => $configuration['captcha_font_path'],
        'font_file' => 'daft.ttf'
    ];

    // Generate a new Text_CAPTCHA object, Image driver
    $c = Text_CAPTCHA::factory('Image');
    $retval = $c->init(200, 60, null, $options);
    if (PEAR::isError($retval)) {
       var_dump($retval);
        $message[] = ['message' => $txt['txt_error_captcha'], 'fields' => ''];
        $captcha_error = true;
    }

    if ($captcha_error == false) {
        // Get CAPTCHA secret passphrase
        $_SESSION["phrase"] = $c->getPhrase();

        // Get CAPTCHA image (as PNG)
        $png = $c->getCAPTCHAAsPNG();
        if (PEAR::isError($png)) {
            $message[] = ['message' => $txt['txt_error_captcha'], 'fields' => ''];
            $captcha_error = true;
        }

        if ($captcha_error == false) {
            file_put_contents($image_temp_path . session_id() . ".png", $png);
            $captcha_note = $txt['txt_captcha_note'];
            $captcha_content = '<img src="' . $image_temp_path . session_id() . '.png?' . time() . '" align="absmiddle" />&nbsp;&nbsp;' .
                 '<input type="text" name="phrase" />';
        }
    }
}
